<?php
// Debug mode
$mondialrelay_debug = get_option( 'mondialrelay_debug');

// Test Mondial Relay webservice (Search point - SOAP)
if (isset($_POST['webservice'])) {
    // Get Mondial Relay global parameters
    $mondialrelay_code_client = get_option( 'mondialrelay_code_client', 1 );
    $mondialrelay_cle_privee = get_option( 'mondialrelay_cle_privee', 1 );
    $client = new soapclient(WC_MondialRelay::MONDIALRELAY_WEBSERVICE);
    $params = array(
        'Enseigne' => $mondialrelay_code_client,
        'Pays'     => 'FR',
        'Ville'    => '',
        'CP'       => '31000',
        'Poids'    => '1000'
    );
    // Generation of the security key
    $code = implode("", $params);
    $code .= $mondialrelay_cle_privee;
    $params["Security"] = strtoupper(md5($code));
    $recherche = $client->WSI2_RecherchePointRelais($params)->WSI2_RecherchePointRelaisResult;
    $noty = 6;
    $callback = $recherche->STAT;
    // Status code
    if ($callback != 0) {
        $libelle_retour = WC_MondialRelay_Helpers::statut($callback);
    }
    // Check required vendor's contact details
    elseif ($callback == 0) {
        // Get sender's parameters
        $params_expediteur = WC_MondialRelay_Order::get_params_expediteur();
        // Get addressee's parameters
        $params_vendeur = array(
            'Enseigne'        => WC_MondialRelay::ENSEIGNE
            ,'ModeCol'        => WC_MondialRelay::MODE_COL
            ,'ModeLiv'        => WC_MondialRelay::MODE_LIV
            ,'Expe_Langage'   => $params_expediteur['mondialrelay_vendeur_langage']
            ,'Expe_Ad1'       => $params_expediteur['mondialrelay_vendeur_adresse1']
            ,'Expe_Ad3'       => $params_expediteur['mondialrelay_vendeur_adresse3']
            ,'Expe_Ad4'       => "Test"
            ,'Expe_Ville'     => $params_expediteur['mondialrelay_vendeur_ville']
            ,'Expe_CP'        => $params_expediteur['mondialrelay_vendeur_cp']
            ,'Expe_Pays'      => $params_expediteur['mondialrelay_vendeur_pays']
            ,'Expe_Tel1'      => $params_expediteur['mondialrelay_vendeur_tel']
            ,'Expe_Mail'      => $params_expediteur['mondialrelay_vendeur_email']
            ,'Dest_Langage'   => "FR"
            ,'Dest_Ad1'       => "Test Test"
            ,'Dest_Ad3'       => "Test"
            ,'Dest_Ville'     => "Test"
            ,'Dest_CP'        => "75000"
            ,'Dest_Pays'      => "FR"
            ,'Dest_Tel1'      => "0100000000"
            ,'Dest_Mail'      => "test@test.fr"
            ,'Poids'          => 1000
            ,'NbColis'        => '1'
            ,'CRT_Valeur'     => '0'
            ,'LIV_Rel_Pays'   => "FR"
            ,'LIV_Rel'        => "021490"
        );
        // Generation of the security key
        $code = implode("", $params_vendeur);
        $code .= 'PrivateK';
        $params_vendeur["Security"] = strtoupper(md5($code));
        // Create the expedition
        $expedition = $client->WSI2_CreationExpedition($params_vendeur)->WSI2_CreationExpeditionResult;
        $vendeur = $expedition->STAT;
        // Status code
        if ($vendeur != 0) {
            $libelle_vendeur_retour = WC_MondialRelay_Helpers::statut($vendeur);
        }
    }
}
