<?php
if (isset($id_livraison_error) && $id_livraison_error == 1) { ?>
    <div class="error">
        <p><?php _e("<strong>Erreur :</strong> les identifiants de livraison Mondial Relay doivent seulement contenir des caractères alpha-numériques ainsi que les caractères \"_\" et \"-\" ", 'woocommerce-mondialrelay') ?></p>
    </div>
<?php } ?>

<h1><?php _e("Configuration du plugin", 'woocommerce-mondialrelay') ?></h1>

<?php
if (isset($noty) && $noty == 1) { ?>
    <div class="updated">
        <p><?php _e("Les options du plugin Mondial Relay pour WooCommerce ont bien été mises à jour.", 'woocommerce-mondialrelay') ?></p>
    </div>
<?php } ?>

<form method="post" action="" id="mondialrelay_admin_recherche">

    <h3><?php _e("Configuration des méthodes de livraison", 'woocommerce-mondialrelay') ?></h3>

    <table class="form-table">
        <tbody>

        <?php if (version_compare(WC_MondialRelay::woocommerce_version(), '2.6.0', '>=')) { ?>
            <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for=""><?php _e('Méthodes de livraison', 'woocommerce_mondialrelay') ?></label>
                    <span class="woocommerce-help-tip" data-tip="<?php _e('Sélectionner les méthodes de livraison que vous souhaitez utiliser avec Mondial Relay', 'woocommerce_mondialrelay') ?>"></span>
                </th>
                <td>
                    <table class="wp-list-table fixed striped">
                        <thead>
                        <th><?php _e("Nom", 'woocommerce-mondialrelay') ?></th>
                        <th><?php _e("Type", 'woocommerce-mondialrelay') ?></th>
                        <th><?php _e("Zone de livraison", 'woocommerce-mondialrelay') ?></th>
                        <th style="text-align: right"><?php _e("Activer", 'woocommerce-mondialrelay') ?></th>
                        </thead>
                        <tbody>
                        <?php foreach($mondialrelay_shipping_methods as $mondialrelay_shipping_method) { ?>
                            <tr>
                                <td><?php echo $mondialrelay_shipping_method['title'] ?></td>
                                <td><?php echo $mondialrelay_shipping_method['name'] ?></td>
                                <td><?php echo $mondialrelay_shipping_method['zone'] ?></td>
                                <td style="text-align: right"><input type="checkbox" id="mondialrelay_ids_livraison" name="mondialrelay_ids_livraison[]" value="<?php echo $mondialrelay_shipping_method['id'] ?>" <?php if(WC_MondialRelay_Configuration::is_active_shipping_method($mondialrelay_shipping_method['id'], $mondialrelay_ids_livraison)) { echo 'checked'; } ?>></td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </td>
            </tr>
        <?php } ?>

        <tr valign="top">
            <th scope="row" class="titledesc"><label for="">
                <?php if (version_compare(WC_MondialRelay::woocommerce_version(), '2.6.0', '>=')) { ?>
                    <?php _e('Méthodes de livraison (obsolètes)', 'woocommerce_mondialrelay') ?></label>
                <?php } else { ?>
                    <?php _e('Méthodes de livraison', 'woocommerce_mondialrelay') ?></label>
                <?php } ?>
                <span class="woocommerce-help-tip" data-tip="<?php _e('Sélectionnez les méthodes de livraison que vous souhaitez utiliser avec Mondial Relay', 'woocommerce_mondialrelay') ?>"></span>
            </th>
            <td>
                <?php if (version_compare(WC_MondialRelay::woocommerce_version(), '2.6.0', '>=')) { ?>
                <p><strong><?php _e('Ces méthodes sont dépréciées depuis la version 2.6.0 de WooCommerce et seront supprimées dans les versions futures - nous vous recommandons de les désactiver et à la place de définir un nouveau taux au sein de vos <a href="/wp-admin/admin.php?page=wc-settings&amp;tab=shipping">Zones de livraison</a>.', 'woocommerce_mondialrelay') ?></strong></p>
                <?php } ?>
                <table class="wp-list-table fixed striped">
                    <thead>
                    <th><?php _e("Méthode de livraison", 'woocommerce-mondialrelay') ?></th>
                    <th style="text-align: right"><?php _e("Activer", 'woocommerce-mondialrelay') ?></th>
                    </thead>
                    <tbody>
                    <?php if ($deprecated_shipping_zones['flat_rate']['enabled'] == 'yes') { ?>
                        <tr>
                            <td><?php _e('Forfait', 'woocommerce_mondialrelay') ?></td>
                            <td style="text-align: right"><input type="checkbox" id="mondialrelay_ids_livraison" name="mondialrelay_ids_livraison[]" value="flat_rate" <?php if(WC_MondialRelay_Configuration::is_active_shipping_method('flat_rate', $mondialrelay_ids_livraison)) { echo 'checked'; } ?>></td>
                        </tr>
                    <?php }
                    if ($deprecated_shipping_zones['free_shipping']['enabled'] == 'yes') { ?>
                        <tr>
                            <td><?php _e('Livraison gratuite', 'woocommerce_mondialrelay') ?></td>
                            <td style="text-align: right"><input type="checkbox" id="mondialrelay_ids_livraison" name="mondialrelay_ids_livraison[]" value="free_shipping" <?php if(WC_MondialRelay_Configuration::is_active_shipping_method('free_shipping', $mondialrelay_ids_livraison)) { echo 'checked'; } ?>></td>
                        </tr>
                    <?php }
                    if ($deprecated_shipping_zones['international_delivery']['enabled'] == 'yes') { ?>
                        <tr>
                            <td><?php _e('Taux fixe international', 'woocommerce_mondialrelay') ?></td>
                            <td style="text-align: right"><input type="checkbox" id="mondialrelay_ids_livraison" name="mondialrelay_ids_livraison[]" value="international_delivery" <?php if(WC_MondialRelay_Configuration::is_active_shipping_method('international_delivery', $mondialrelay_ids_livraison)) { echo 'checked'; } ?>></td>
                        </tr>
                    <?php }
                    if ($deprecated_shipping_zones['local_pickup']['enabled'] == 'yes') { ?>
                        <tr>
                            <td><?php _e('Point de vente', 'woocommerce_mondialrelay') ?></td>
                            <td style="text-align: right"><input type="checkbox" id="mondialrelay_ids_livraison" name="mondialrelay_ids_livraison[]" value="local_pickup" <?php if(WC_MondialRelay_Configuration::is_active_shipping_method('local_pickup', $mondialrelay_ids_livraison)) { echo 'checked'; } ?>></td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for=""><?php _e('Méthodes de livraison (manuel)', 'woocommerce_mondialrelay') ?></label>
                <span class="woocommerce-help-tip" data-tip="<?php _e("Indiquez un ou plusieurs identifiants de méthodes de livraison, séparés par des virgules.<br><strong>Ex : local_pickup, flat_rate", "woocommerce_mondialrelay") ?>"></span>
            </th>
            <td>
                <p><strong><?php _e("Vous pouvez aussi définir manuellement les identifiants des méthodes de livraison que vous souhaitez associer à Mondial Relay.", "woocommerce_mondialrelay") ?><br>
                        <?php _e("Attention : ce champ est prioritaire sur les autres champs précédents. Les réglages effectués au-dessus ne seront pas pris en compte si celui est renseigné.", "woocommerce_mondialrelay") ?></strong></p>
                <br>
                <?php _e("Actuellement défini :", "woocommerce_mondialrelay") ?>
                <pre><?php echo $mondialrelay_ids_livraison_manual ?></pre>
                <input class="regular-text" type="text" id="mondialrelay_ids_livraison_manual" name="mondialrelay_ids_livraison_manual" value="">
            </td>
        </tr>

        </tbody>
    </table>

    <br>

    <h3><?php _e("Personnalisation des textes", 'woocommerce-mondialrelay') ?></h3>
<table class="form-table">
    <tbody>
    <?php foreach ($labels_webmarketing as $key => $label) {
        $champs[$key] = str_replace('\\', '', $champs[$key]);
        ?>
        <tr valign="top">
            <th scope="row" class="titledesc"><label><?php echo $label['label']; ?> </label> <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span></th>
            <td>
                <?php if ($label['type'] == 'textarea') { ?>
                    <textarea class="regular-text" name="<?php echo $key ?>" cols="80"><?php echo $champs[$key];  ?></textarea>
                <?php } ?>
            </td>
        </tr>
    <?php } ?>
    </tbody>
</table>

    <br>

    <h3><?php _e("Personnalisation du style", 'woocommerce-mondialrelay') ?></h3>
    <table class="form-table">
        <tbody>
        <?php foreach ($labels_specifiques as $key => $label) { ?>
            <tr valign="top">
                <th scope="row" class="titledesc"><label><?php echo $label['label']; ?> </label> <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span></th>
                <td>
                    <?php if ($label['type'] == 'textarea') { ?>
                        <textarea class="regular-text" name="<?php echo $key ?>" cols="80" rows="10"><?php echo stripslashes($champs[$key]); ?></textarea>
                    <?php } ?>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <br>

    <h3><?php _e("Configuration du widget Parcelshop Picker de Mondial Relay", 'woocommerce-mondialrelay') ?></h3>
    <table class="form-table">
        <tbody>
        <?php foreach ($labels_widget as $key => $label) { ?>
            <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="<?php echo $key ?>"><?php echo $label['label']; ?> </label>
                    <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span>
                </th>
                <td>
                    <select name="<?php echo $key ?>">
                        <option value="" disabled> <?php _e("Choisir", 'woocommerce-mondialrelay') ?>
                            <?php
                            foreach($label['options'] as $option) { ?>
                        <option value="<?php echo $option ?>" <?php if ($champs[$key] == $option) echo 'selected'; ?>> <?php echo $option ?>
                            <?php }
                            ?>
                    </select>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <br>

    <h3><?php _e("Google Map", 'woocommerce-mondialrelay') ?></h3>
    <table class="form-table">
        <tbody>
        <?php foreach ($labels_google_map as $key => $label) { ?>
            <tr valign="top">
                <th scope="row" class="titledesc"><label><?php echo $label['label']; ?> </label> <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span></th>
                <td>
                    <?php if ($label['type'] == 'text') { ?>
                        <input name="<?php echo $key ?>" type="text" id="<?php echo $key ?>" value="<?php echo $champs[$key]; ?>" class="regular-text">
                    <?php } elseif ($label['type'] == 'radio') { ?>
                        <input type="radio" name="<?php echo $key ?>" id="<?php echo $key . '_oui' ?>" value="true" <?php if ($champs[$key] == 'true') echo 'checked'; ?>><label for="<?php echo $key . '_oui' ?>"><?php _e("Oui", 'woocommerce-mondialrelay') ?></label>
                        <input type="radio" name="<?php echo $key ?>" id="<?php echo $key . '_non' ?>" value="false" <?php if ($champs[$key] == 'false') echo 'checked'; ?>><label for="<?php echo $key . '_non' ?>"><?php _e("Non", 'woocommerce-mondialrelay') ?></label>
                    <?php } ?>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <br>

    <h3><?php _e("Fancybox", 'woocommerce-mondialrelay') ?></h3>
    <table class="form-table">
        <tbody>
        <?php foreach ($labels_fancybox as $key => $label) { ?>
            <tr valign="top">
                <th scope="row" class="titledesc"><label><?php echo $label['label']; ?> </label> <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span></th>
                <td>
                    <input type="radio" name="<?php echo $key ?>" id="<?php echo $key . '_oui' ?>" value="true" <?php if ($champs[$key] == 'true') echo 'checked'; ?>><label for="<?php echo $key . '_oui' ?>"><?php _e("Oui", 'woocommerce-mondialrelay') ?></label>
                    <input type="radio" name="<?php echo $key ?>" id="<?php echo $key . '_non' ?>" value="false" <?php if ($champs[$key] == 'false') echo 'checked'; ?>><label for="<?php echo $key . '_non' ?>"><?php _e("Non", 'woocommerce-mondialrelay') ?></label>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <br>

    <h3><?php _e("Etat de commande après création d'une expédition", 'woocommerce-mondialrelay') ?></h3>
    <table class="form-table">
        <tbody>
        <?php foreach ($labels_order as $key => $label) { ?>
            <tr valign="top">
                <th scope="row" class="titledesc">
                    <label for="<?php echo $key ?>"><?php echo $label['label']; ?> </label>
                    <span class="woocommerce-help-tip" data-tip="<?php echo $label['description'] ?>"></span>
                </th>
                <td>
                    <select name="<?php echo $key ?>">
                        <option value=""> <?php _e("Ne rien faire", 'woocommerce-mondialrelay') ?>
                            <?php
                            foreach($label['options'] as $value => $option) { ?>
                        <option value="<?php echo $value ?>" <?php if ($champs[$key] == $value) echo 'selected'; ?>> <?php echo $option ?>
                            <?php }
                            ?>
                    </select>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>

    <br>

    <p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php _e("Enregistrer les changements", 'woocommerce-mondialrelay') ?>"></p>

</form>

<div id="message" class="woocommerce-mondialrelay-message">
    <div class="squeezer">
        <p><strong><?php _e("Aide", 'woocommerce-mondialrelay') ?></strong><br>
            <?php _e("Pour plus d'informations sur les options du plugin, consultez", 'woocommerce-mondialrelay') ?> <a target="_blank" href="<?php echo WC_MondialRelay::DOCUMENTATION; ?>/configuration"> <?php _e("la documentation", 'woocommerce-mondialrelay') ?></a>.</p>
    </div>
</div>