<?php

// Attributes forms
if (isset($_POST['mondialrelay_ids_livraison']) && $_POST['mondialrelay_ids_livraison'] != '') {
    $mondialrelay_ids_livraison = $_POST['mondialrelay_ids_livraison'];
}
else {
    $mondialrelay_ids_livraison = '';
}

if (isset($_POST['mondialrelay_ids_livraison_manual']) && $_POST['mondialrelay_ids_livraison_manual'] != '') {
    $mondialrelay_ids_livraison_manual = $_POST['mondialrelay_ids_livraison_manual'];
}
else {
    $mondialrelay_ids_livraison_manual = null;
}

if (isset($_POST['mondialrelay_texte_selection']) && $_POST['mondialrelay_texte_selection'] != '') {
    $mondialrelay_texte_selection = $_POST['mondialrelay_texte_selection'];
}
else {
    $mondialrelay_texte_selection = __("Cliquez ici pour choisir un point de livraison Mondial Relay", 'woocommerce-mondialrelay');
}
if (isset($_POST['mondialrelay_texte_aucun']) && $_POST['mondialrelay_texte_aucun'] != '') {
    $mondialrelay_texte_aucun = $_POST['mondialrelay_texte_aucun'];
}
else {
    $mondialrelay_texte_aucun = __("Vous n'avez pas sélectionné de point Mondial Relay", 'woocommerce-mondialrelay');
}
if (isset($_POST['mondialrelay_texte_choix']) && $_POST['mondialrelay_texte_choix'] != '') {
    $mondialrelay_texte_choix = $_POST['mondialrelay_texte_choix'];
}
else {
    $mondialrelay_texte_choix = __("Choisir ce point Mondial Relay", 'woocommerce-mondialrelay');
}
if (isset($_POST['mondialrelay_texte_erreur']) && $_POST['mondialrelay_texte_erreur'] != '') {
    $mondialrelay_texte_erreur = $_POST['mondialrelay_texte_erreur'];
}
else {
    $mondialrelay_texte_erreur = __("Veuillez sélectionner un point relais", 'woocommerce-mondialrelay');
}

if (isset($_POST['mondialrelay_style']) && $_POST['mondialrelay_style'] != '') {
    $mondialrelay_style = $_POST['mondialrelay_style'];
}
else {
    $mondialrelay_style = '';
}

if (isset($_POST['mondialrelay_parcelshop_picker']) && $_POST['mondialrelay_parcelshop_picker'] != '') {
    $mondialrelay_parcelshop_picker = $_POST['mondialrelay_parcelshop_picker'];
}
else {
    $mondialrelay_parcelshop_picker = '';
}

if (isset($_POST['mondialrelay_google_map_init']) && $_POST['mondialrelay_google_map_init'] != '') {
    $mondialrelay_google_map_init = $_POST['mondialrelay_google_map_init'];
}
else {
    $mondialrelay_google_map_init = '';
}

if (isset($_POST['mondialrelay_google_map_key']) && $_POST['mondialrelay_google_map_key'] != '') {
    $mondialrelay_google_map_key = $_POST['mondialrelay_google_map_key'];
}
else {
    $mondialrelay_google_map_key = '';
}

if (isset($_POST['mondialrelay_fancybox_init']) && $_POST['mondialrelay_fancybox_init'] != '') {
    $mondialrelay_fancybox_init = $_POST['mondialrelay_fancybox_init'];
}
else {
    $mondialrelay_fancybox_init = '';
}

if (isset($_POST['mondialrelay_state_order']) && $_POST['mondialrelay_state_order'] != '') {
    $mondialrelay_state_order = $_POST['mondialrelay_state_order'];
}
else {
    $mondialrelay_state_order = '';
}

// Save the attributes forms
$champs = array(
    'mondialrelay_style'             => $mondialrelay_style,
    'mondialrelay_texte_selection'   => $mondialrelay_texte_selection,
    'mondialrelay_texte_aucun'       => $mondialrelay_texte_aucun,
    'mondialrelay_texte_choix'       => $mondialrelay_texte_choix,
    'mondialrelay_texte_erreur'      => $mondialrelay_texte_erreur,
    'mondialrelay_parcelshop_picker' => $mondialrelay_parcelshop_picker,
    'mondialrelay_google_map_key'    => $mondialrelay_google_map_key,
    'mondialrelay_google_map_init'   => $mondialrelay_google_map_init,
    'mondialrelay_fancybox_init'     => $mondialrelay_fancybox_init,
    'mondialrelay_state_order'       => $mondialrelay_state_order,
);

// Labels of the webmarketing Mondial Relay attributes form
$labels_webmarketing['mondialrelay_texte_selection']['label'] = __("Texte de sélection de point relais", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_selection']['description'] = '<strong>' . __("Ex : Cliquez ici pour choisir un point de livraison Mondial Relay", 'woocommerce-mondialrelay') . '</strong> ' . __("(par défaut)", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_selection']['type'] = "textarea";
$labels_webmarketing['mondialrelay_texte_aucun']['label'] = __("Texte si aucun point relais n'est sélectionné", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_aucun']['description'] = '<strong>' . __("Ex : Vous n'avez pas sélectionné de point Mondial Relay", 'woocommerce-mondialrelay') . '</strong> ' . __("(par défaut)", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_aucun']['type'] = "textarea";
$labels_webmarketing['mondialrelay_texte_choix']['label'] = __("Texte du bouton de sélection de point relais", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_choix']['description'] = '<strong>' . __("Ex : Choisir ce point Mondial Relay", 'woocommerce-mondialrelay') . '</strong> ' . __("(par défaut)", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_choix']['type'] = "textarea";
$labels_webmarketing['mondialrelay_texte_erreur']['label'] = __("Texte d'erreur si l'utilisateur n'a pas sélectionné de point relais", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_erreur']['description'] = '<strong>' . __("Ex : Veuillez sélectionner un point relais", 'woocommerce-mondialrelay') . '</strong> ' . __("(par défaut)", 'woocommerce-mondialrelay');
$labels_webmarketing['mondialrelay_texte_erreur']['type'] = "textarea";

// Labels of the specific Mondial Relay attributes form
$labels_specifiques['mondialrelay_style']['label'] = __("Style CSS spécifique", 'woocommerce-mondialrelay');
$labels_specifiques['mondialrelay_style']['description'] = __("Surcharger le style CSS de votre thème sur la page \"Checkout\"", 'woocommerce-mondialrelay');
$labels_specifiques['mondialrelay_style']['type'] = "textarea";

// Labels of the Mondial Relay parcelshop picker attributes form
$labels_widget['mondialrelay_parcelshop_picker']['label'] = __("Version de Parcelshop Picker", 'woocommerce-mondialrelay');
$labels_widget['mondialrelay_parcelshop_picker']['description'] = __("Version du widget Parcelshop Picker de Mondial Relay<br><strong>Ex : 3.2</strong> (par défaut)", 'woocommerce-mondialrelay');
$labels_widget['mondialrelay_parcelshop_picker']['type'] = "select";
$labels_widget['mondialrelay_parcelshop_picker']['options'] = array('3.2', '3.1', '3.0');

// Labels of the Mondial Relay Google Map attributes form
$labels_google_map['mondialrelay_google_map_init']['label'] = __("Initialisation du script", 'woocommerce-mondialrelay');
$labels_google_map['mondialrelay_google_map_init']['description'] = __("Chargement du script Google Map", 'woocommerce-mondialrelay');
$labels_google_map['mondialrelay_google_map_init']['type'] = "radio";
$labels_google_map['mondialrelay_google_map_key']['label'] = __("Clé API", 'woocommerce-mondialrelay');
$labels_google_map['mondialrelay_google_map_key']['description'] = __("Clé API de Google Map", 'woocommerce-mondialrelay');
$labels_google_map['mondialrelay_google_map_key']['type'] = "text";

// Labels of the Mondial Relay Fancybox attributes form
$labels_fancybox['mondialrelay_fancybox_init']['label'] = __("Initialisation du script et du style", 'woocommerce-mondialrelay');
$labels_fancybox['mondialrelay_fancybox_init']['description'] = __("Chargement du script Fancybox", 'woocommerce-mondialrelay');
$labels_fancybox['mondialrelay_fancybox_init']['type'] = "radio";

// Labels of the Mondial Relay state order parameter form
$labels_order['mondialrelay_state_order']['label'] = __("Etat de commande", 'woocommerce-mondialrelay');
$labels_order['mondialrelay_state_order']['description'] = __("Etat de commande lors de la création d'une expédition Mondial Relay<br><strong>Ex: Ne rien faire</strong> (par défault)", 'woocommerce-mondialrelay');
$labels_order['mondialrelay_state_order']['type'] = "select";
$labels_order['mondialrelay_state_order']['options'] = array(
    'wc-pending' => __('Attente paiement', 'woocommerce-mondialrelay'),
    'wc-processing' => __('En cours', 'woocommerce-mondialrelay'),
    'wc-on-hold' => __('En attente', 'woocommerce-mondialrelay'),
    'wc-completed' => __('Terminé', 'woocommerce-mondialrelay'),
    'wc-cancelled' => __('Annulée', 'woocommerce-mondialrelay'),
    'wc-refunded' => __('Remboursé', 'woocommerce-mondialrelay'),
    'wc-failed' => __('Échoué', 'woocommerce-mondialrelay')
);

// Update options
if (isset($_POST['submit'])) {
    $envoi = 1;
    $noty = 1;
    WC_MondialRelay_Sql::update_options_champs($champs);
    if ($mondialrelay_ids_livraison_manual) {
        $mondialrelay_ids_livraison_converted = str_replace(' ', '', $mondialrelay_ids_livraison_manual);
        $mondialrelay_ids_livraison_converted = explode(',', $mondialrelay_ids_livraison_converted);
        update_option('mondialrelay_ids_livraison', $mondialrelay_ids_livraison_converted);
    }
    else {
        update_option('mondialrelay_ids_livraison', $mondialrelay_ids_livraison);
    }
}

// Get the options
$champs = WC_MondialRelay_Sql::get_options_champs($champs);
$mondialrelay_ids_livraison = WC_MondialRelay_Sql::get_options_champ('mondialrelay_ids_livraison');
$mondialrelay_ids_livraison = unserialize($mondialrelay_ids_livraison);

if (version_compare(WC_MondialRelay::woocommerce_version(), '2.6.0', '>=')) {
    // Get WooCommerce shipping methods
    $shipping_methods = WC_MondialRelay_Sql::get_shipping_methods();

    $mondialrelay_shipping_methods = array();
    foreach($shipping_methods as $key => $shipping_method) {
        $mondialrelay_shipping_methods[$key] = array(
            'id' => $shipping_method->method_id . ':' . $shipping_method->instance_id,
            'zone' => WC_MondialRelay_Helpers::get_shipping_zone_name($shipping_method->zone_id),
            'name' => WC_MondialRelay_Helpers::get_shipping_method_name($shipping_method->method_id),
            'title' => WC_MondialRelay_Sql::get_shipping_method_title($shipping_method->method_id, $shipping_method->instance_id),
        );
    }
}

$deprecated_shipping_zones = WC_MondialRelay_Sql::get_deprecated_shipping_zones();

$mondialrelay_ids_livraison_manual = '';
$i = 0;
if (is_array($mondialrelay_ids_livraison)) {
    foreach ($mondialrelay_ids_livraison as $mondialrelay_id_livraison) {
        if ($i > 0) {
            $mondialrelay_ids_livraison_manual .= ', ';
        }
        $mondialrelay_ids_livraison_manual .= $mondialrelay_id_livraison;
        $i++;
    }
}
